DROP PROCEDURE [hips].[AddressDelete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 15 October 2012
-- Description:   Deletes an existing record from the Addresss Table
-- =============================================
CREATE PROCEDURE [hips].[AddressDelete] 
(
	  @AddressId INT
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int,
			@intRowsAffected int

    SELECT  @intErrorCode = 0,
			@intRowsAffected = 0

    DELETE
     FROM [hips].[Address]
     WHERE [AddressId] = @AddressId

    SELECT @intErrorCode = @@ERROR,
   		   @intRowsAffected = @@ROWCOUNT

	SELECT @intRowsAffected AS RowsAffected

    RETURN(@intErrorCode)
END
GO

